﻿using System;
using System.Text;

namespace EncodingExamples
{
    class Program
    {
        // Listing 10-80. Kodowanie tekstu.
        static void Main(string[] args)
        {
            string listenUp = "Ludzie, pomocy!";
            byte[] utf8Bytes = Encoding.UTF8.GetBytes(listenUp);
            byte[] asciiBytes = Encoding.ASCII.GetBytes(listenUp);
            Console.WriteLine("UTF-8");
            Console.WriteLine("-----");
            foreach (var encodedByte in utf8Bytes)
            {
                Console.Write(encodedByte);
                Console.Write(" ");
            }
            Console.WriteLine();
            Console.WriteLine();
            Console.WriteLine("ASCII");
            Console.WriteLine("-----");
            foreach (var encodedByte in asciiBytes)
            {
                Console.Write(encodedByte);
                Console.Write(" ");
            }
            Console.ReadKey();

            NonAscii();
        }

        private static void NonAscii()
        {
            // Listing 10-81. Stosowanie znaków spoza kodu ASCII.
            string listenUp = "Écoute-moi!";
            byte[] utf8Bytes = Encoding.UTF8.GetBytes(listenUp);
            byte[] asciiBytes = Encoding.ASCII.GetBytes(listenUp);
            Console.WriteLine("UTF-8");
            Console.WriteLine("-----");
            foreach (var encodedByte in utf8Bytes)
            {
                Console.Write(encodedByte);
                Console.Write(" ");
            }
            Console.WriteLine();
            Console.WriteLine();
            Console.WriteLine("ASCII");
            Console.WriteLine("-----");
            foreach (var encodedByte in asciiBytes)
            {
                Console.Write(encodedByte);
                Console.Write(" "); 
            }

            // Listing 10-82. Dekodowanie tekstu
            string decodedUtf8 = Encoding.UTF8.GetString(utf8Bytes);
            string decodedAscii = Encoding.ASCII.GetString(asciiBytes);
            Console.WriteLine();
            Console.WriteLine();
            Console.WriteLine("Zdekodowane z UTF-8");
            Console.WriteLine("-------------");
            Console.WriteLine(decodedUtf8);
            Console.WriteLine();
            Console.WriteLine();
            Console.WriteLine("Zdekodowane z ASCII");
            Console.WriteLine("-------------");
            Console.WriteLine(decodedAscii);

            Console.ReadKey();
        }
    }
}
